/*
 * Decompiled with CFR 0.152.
 */
package tux2.MonsterBox;

import com.nijiko.permissions.PermissionHandler;
import com.nijikokun.bukkit.Permissions.Permissions;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.PluginCommand;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;
import org.getspout.spout.Spout;
import tux2.MonsterBox.CreatureTypes;
import tux2.MonsterBox.MonsterBoxBlockListener;
import tux2.MonsterBox.MonsterBoxCommands;
import tux2.MonsterBox.MonsterBoxPlayerListener;
import tux2.MonsterBox.MonsterBoxScreenListener;
import tux2.MonsterBox.SpoutStuff;

public class MonsterBox
extends JavaPlugin {
    private final HashMap<Player, Boolean> debugees = new HashMap();
    private final ConcurrentHashMap<String, Double> mobprice = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Double> mobeggprice = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, LinkedList<EntityType>> disabledspawners = new ConcurrentHashMap();
    ConcurrentHashMap<String, Integer> disabledspawnerlocs = new ConcurrentHashMap();
    private static PermissionHandler Permissions;
    public MonsterBoxBlockListener bl;
    public Economy iConomy = null;
    boolean useiconomy = false;
    public double iconomyprice = 0.0;
    public Spout usespout = null;
    public boolean separateprices = false;
    public int tool = Material.GOLD_SWORD.getId();
    public int buttonwidth = 80;
    public String version = "0.8";
    public SpoutStuff ss = null;
    public HashSet<Byte> transparentBlocks = new HashSet();
    private ConcurrentHashMap<String, String> mobcase = new ConcurrentHashMap();
    public String eggthrowmessage = "I'm sorry, but you can't spawn that mob.";
    public boolean needssilktouch = false;
    public double eggprice = 0.0;
    public boolean separateeggprices = false;
    public String blocksavefile = "plugins/MonsterBox/disabledspawners.list";

    public MonsterBox() {
        this.loadconfig();
        this.loadprices();
        this.loadeggprices();
        this.loadDisabledSpawners();
        this.transparentBlocks.add((byte)0);
        this.transparentBlocks.add((byte)8);
        this.transparentBlocks.add((byte)9);
        this.transparentBlocks.add((byte)20);
        this.transparentBlocks.add((byte)30);
        this.transparentBlocks.add((byte)65);
        this.transparentBlocks.add((byte)66);
        this.transparentBlocks.add((byte)78);
        this.transparentBlocks.add((byte)83);
        this.transparentBlocks.add((byte)101);
        this.transparentBlocks.add((byte)102);
        this.transparentBlocks.add((byte)106);
    }

    private void loadprices() {
        File folder = new File("plugins/MonsterBox");
        File configFile = new File("plugins/MonsterBox/prices.ini");
        if (configFile.exists()) {
            try {
                this.mobprice.clear();
                Properties theprices = new Properties();
                theprices.load(new FileInputStream(configFile));
                for (Map.Entry<Object, Object> price : theprices.entrySet()) {
                    try {
                        this.mobprice.put(price.getKey().toString().toLowerCase(), new Double(price.getValue().toString()));
                    }
                    catch (NumberFormatException ex) {
                        System.out.println("[MonsterBox] Unable to parse the value for " + price.getKey().toString());
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (this.mobprice.size() < CreatureTypes.values().length) {
                System.out.println("[MonsterBox] - New mobs found! Updating prices.ini");
                this.createprices();
            }
        } else {
            System.out.println("[MonsterBox] Price file not found");
            folder.mkdir();
            System.out.println("[MonsterBox] - creating file prices.ini");
            this.createprices();
        }
    }

    private void loadeggprices() {
        File folder = new File("plugins/MonsterBox");
        File configFile = new File("plugins/MonsterBox/eggprices.ini");
        if (configFile.exists()) {
            try {
                this.mobeggprice.clear();
                Properties theprices = new Properties();
                theprices.load(new FileInputStream(configFile));
                for (Map.Entry<Object, Object> price : theprices.entrySet()) {
                    try {
                        this.mobeggprice.put(price.getKey().toString().toLowerCase(), new Double(price.getValue().toString()));
                    }
                    catch (NumberFormatException ex) {
                        System.out.println("[MonsterBox] Unable to parse the value for " + price.getKey().toString() + "in the eggprices.ini file.");
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (this.mobeggprice.size() < CreatureTypes.values().length) {
                System.out.println("[MonsterBox] - New mobs found! Updating eggprices.ini");
                this.createeggprices();
            }
        } else {
            System.out.println("[MonsterBox] Egg price file not found");
            folder.mkdir();
            System.out.println("[MonsterBox] - creating file eggprices.ini");
            this.createeggprices();
        }
    }

    private void createprices() {
        try {
            CreatureTypes[] mobs;
            BufferedWriter outChannel = new BufferedWriter(new FileWriter("plugins/MonsterBox/prices.ini"));
            outChannel.write("#This config file contains all the separate prices for all the mobs\n# if the option separateprices is true\n\n\n");
            CreatureTypes[] creatureTypesArray = mobs = CreatureTypes.values();
            int n = mobs.length;
            int n2 = 0;
            while (n2 < n) {
                CreatureTypes mob = creatureTypesArray[n2];
                outChannel.write(String.valueOf(mob.toString()) + " = " + String.valueOf(this.getMobPrice(mob.toString())) + "\n");
                ++n2;
            }
            outChannel.close();
        }
        catch (Exception e) {
            System.out.println("[MonsterBox] - Prices file creation failed, using defaults.");
        }
    }

    private void createeggprices() {
        try {
            CreatureTypes[] mobs;
            BufferedWriter outChannel = new BufferedWriter(new FileWriter("plugins/MonsterBox/eggprices.ini"));
            outChannel.write("#This config file contains all the separate prices for all the mobs\n# for eggs if the option separateeggprices is true\n\n\n");
            CreatureTypes[] creatureTypesArray = mobs = CreatureTypes.values();
            int n = mobs.length;
            int n2 = 0;
            while (n2 < n) {
                CreatureTypes mob = creatureTypesArray[n2];
                outChannel.write(String.valueOf(mob.toString()) + " = " + String.valueOf(this.getEggMobPrice(mob.toString())) + "\n");
                ++n2;
            }
            outChannel.close();
        }
        catch (Exception e) {
            System.out.println("[MonsterBox] - Egg prices file creation failed, using defaults.");
        }
    }

    public void onEnable() {
        this.setupPermissions();
        this.setupSpout();
        this.setupMobCase();
        PluginManager pm = this.getServer().getPluginManager();
        this.bl = new MonsterBoxBlockListener(this);
        MonsterBoxPlayerListener pl = new MonsterBoxPlayerListener(this);
        if (this.useiconomy) {
            this.setupEconomy();
        }
        pm.registerEvents((Listener)this.bl, (Plugin)this);
        pm.registerEvents((Listener)pl, (Plugin)this);
        if (this.usespout != null) {
            pm.registerEvents((Listener)new MonsterBoxScreenListener(this), (Plugin)this);
            this.ss = new SpoutStuff(this);
        }
        MonsterBoxCommands commandL = new MonsterBoxCommands(this);
        PluginCommand batchcommand = this.getCommand("mbox");
        batchcommand.setExecutor((CommandExecutor)commandL);
        PluginDescriptionFile pdfFile = this.getDescription();
        System.out.println(String.valueOf(pdfFile.getName()) + " version " + pdfFile.getVersion() + " is enabled!");
    }

    public void onDisable() {
        System.out.println("MonsterBox disabled!");
    }

    public boolean isDebugging(Player player) {
        if (this.debugees.containsKey(player)) {
            return this.debugees.get(player);
        }
        return false;
    }

    public void setDebugging(Player player, boolean value) {
        this.debugees.put(player, value);
    }

    private void setupPermissions() {
        Plugin permissions = this.getServer().getPluginManager().getPlugin("Permissions");
        if (Permissions == null && permissions != null) {
            Permissions = ((Permissions)permissions).getHandler();
        }
    }

    private void setupSpout() {
        Plugin p = this.getServer().getPluginManager().getPlugin("Spout");
        if (p == null) {
            this.usespout = null;
            System.out.println("[MonsterBox] Spout not detected. Disabling spout support.");
        } else {
            try {
                this.usespout = (Spout)p;
            }
            catch (Exception e) {
                System.out.println("[MonsterBox] Error hooking into spout. Disabling spout support.");
            }
            System.out.println("[MonsterBox] Spout detected. Spout support enabled.");
        }
    }

    public boolean hasPermissions(Player player, String node) {
        if (Permissions != null) {
            return Permissions.has(player, node);
        }
        return player.hasPermission(node);
    }

    private void loadconfig() {
        File folder = new File("plugins/MonsterBox");
        File configFile = new File("plugins/MonsterBox/settings.ini");
        if (configFile.exists()) {
            try {
                Properties themapSettings = new Properties();
                themapSettings.load(new FileInputStream(configFile));
                String iconomy = themapSettings.getProperty("useEconomy", "false");
                String price = themapSettings.getProperty("price", "0.0");
                String eggsprice = themapSettings.getProperty("eggprice", "0.0");
                String sprices = themapSettings.getProperty("separateprices", "false");
                String seggprices = themapSettings.getProperty("separateeggprices", "false");
                String swidth = themapSettings.getProperty("buttonwidth", "100");
                String stool = themapSettings.getProperty("changetool", String.valueOf(Material.GOLD_SWORD.getId()));
                String theversion = themapSettings.getProperty("version", "0.1");
                this.eggthrowmessage = themapSettings.getProperty("eggdenymessage", this.eggthrowmessage);
                String silktouch = themapSettings.getProperty("needssilktouch", "false");
                this.needssilktouch = this.stringToBool(silktouch);
                this.useiconomy = this.stringToBool(iconomy);
                this.separateprices = this.stringToBool(sprices);
                this.separateeggprices = this.stringToBool(seggprices);
                try {
                    this.tool = Integer.parseInt(stool.trim());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    this.buttonwidth = Integer.parseInt(swidth.trim());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    this.iconomyprice = Double.parseDouble(price.trim());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    this.eggprice = Double.parseDouble(eggsprice.trim());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                double dbversion = 0.1;
                try {
                    dbversion = Double.parseDouble(theversion.trim());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (dbversion < 0.8) {
                    if (dbversion == 0.1) {
                        String sconomy = themapSettings.getProperty("useiConomy", "false");
                        this.useiconomy = this.stringToBool(sconomy);
                    }
                    this.updateIni();
                }
            }
            catch (IOException iOException) {}
        } else {
            System.out.println("[MonsterBox] Configuration file not found");
            System.out.println("[MonsterBox] + creating folder plugins/MonsterBox");
            folder.mkdir();
            System.out.println("[MonsterBox] - creating file settings.ini");
            this.updateIni();
        }
    }

    private void updateIni() {
        try {
            BufferedWriter outChannel = new BufferedWriter(new FileWriter("plugins/MonsterBox/settings.ini"));
            outChannel.write("#This is the main MonsterBox config file\n#\n# useiConomy: Charge to change monster spawner type using your economy system\nuseEconomy = " + this.useiconomy + "\n" + "# price: The price to change monster spawner type\n" + "price = " + this.iconomyprice + "\n\n" + "# eggprice: The price to change monster spawner type using eggs\n" + "eggprice = " + this.eggprice + "\n\n" + "# separateprices: If you want separate prices for all the different types of mobs\n" + "# set this to true.\n" + "separateprices = " + this.separateprices + "\n" + "# separateeggprices: If you want separate prices for all the different types of mobs\n" + "# set this to true.\n" + "separateeggprices = " + this.separateeggprices + "\n" + "# changetool is the tool that opens up the spout gui for changing the monster spawner.\n" + "changetool = " + this.tool + "\n" + "# needssilktouch Does the player need a silk touch enchanted tool to get a spawner?.\n" + "needssilktouch = " + this.needssilktouch + "\n" + "# buttonwidth changes the width of the buttons in the spoutcraft gui, just in case the\n" + "# text doesn't fit for you.\n" + "buttonwidth = " + this.buttonwidth + "\n\n" + "# eggdenymessage sets the message displayed to players when they are denied egg spawning\n" + "# if they have the monsterbox.eggthrowmessage permission node.\n" + "eggdenymessage = " + this.eggthrowmessage + "\n\n" + "#Do not change anything below this line unless you know what you are doing!\n" + "version = " + this.version);
            outChannel.close();
        }
        catch (Exception e) {
            System.out.println("[MonsterBox] - file creation failed, using defaults.");
        }
    }

    public boolean hasEconomy() {
        if (this.iConomy != null) {
            return this.iConomy.isEnabled();
        }
        return false;
    }

    private synchronized boolean stringToBool(String thebool) {
        boolean result = thebool.trim().equalsIgnoreCase("true") || thebool.trim().equalsIgnoreCase("yes");
        return result;
    }

    boolean setSpawner(Block targetBlock, String type) {
        EntityType ct;
        CreatureSpawner theSpawner;
        block8: {
            block9: {
                try {
                    theSpawner = (CreatureSpawner)targetBlock.getState();
                    type = this.mobcase.containsKey(type.toLowerCase().trim()) ? this.mobcase.get(type.toLowerCase().trim()) : this.capitalCase(type);
                    ct = EntityType.fromName((String)type);
                    if (ct != null) break block8;
                    if (!type.equalsIgnoreCase("ocelot")) break block9;
                    theSpawner.setSpawnedType(EntityType.OCELOT);
                    if (this.disabledspawnerlocs.containsKey(this.locationBuilder(targetBlock.getLocation()))) {
                        this.removeDisabledSpawner(targetBlock);
                    }
                    return true;
                }
                catch (Exception e) {
                    return false;
                }
            }
            if (type.equalsIgnoreCase("IronGolem")) {
                theSpawner.setSpawnedType(EntityType.IRON_GOLEM);
                if (this.disabledspawnerlocs.containsKey(this.locationBuilder(targetBlock.getLocation()))) {
                    this.removeDisabledSpawner(targetBlock);
                }
                return true;
            }
            return false;
        }
        theSpawner.setSpawnedType(ct);
        if (this.disabledspawnerlocs.containsKey(this.locationBuilder(targetBlock.getLocation()))) {
            this.removeDisabledSpawner(targetBlock);
        }
        return true;
    }

    String capitalCase(String s) {
        return String.valueOf(s.toUpperCase().charAt(0)) + s.toLowerCase().substring(1);
    }

    public double getMobPrice(String name) {
        if (this.separateprices && this.mobprice.containsKey(name.toLowerCase())) {
            return this.mobprice.get(name.toLowerCase());
        }
        return this.iconomyprice;
    }

    public double getEggMobPrice(String name) {
        if (this.separateeggprices && this.mobeggprice.containsKey(name.toLowerCase())) {
            return this.mobeggprice.get(name.toLowerCase());
        }
        return this.eggprice;
    }

    private void setupMobCase() {
        CreatureTypes[] mobs;
        CreatureTypes[] creatureTypesArray = mobs = CreatureTypes.values();
        int n = mobs.length;
        int n2 = 0;
        while (n2 < n) {
            CreatureTypes mob = creatureTypesArray[n2];
            String mobname = mob.toString().trim();
            this.mobcase.put(mobname.toLowerCase(), mobname);
            ++n2;
        }
    }

    private void setupEconomy() {
        RegisteredServiceProvider economyProvider = this.getServer().getServicesManager().getRegistration(Economy.class);
        if (economyProvider != null) {
            this.iConomy = (Economy)economyProvider.getProvider();
        }
    }

    public boolean canSpawnMob(Location loc, EntityType type) {
        String locname = this.locationBuilder(loc);
        if (this.disabledspawners.containsKey(locname)) {
            return !this.disabledspawners.get(locname).contains(type);
        }
        return true;
    }

    public String locationBuilder(Location loc) {
        return String.valueOf(loc.getBlockX()) + "." + loc.getBlockY() + "." + loc.getBlockZ() + "." + loc.getWorld().getName();
    }

    public void addDisabledSpawner(Block spawner) {
        if (spawner.getType() == Material.MOB_SPAWNER) {
            CreatureSpawner theSpawner = (CreatureSpawner)spawner.getState();
            EntityType mobname = theSpawner.getSpawnedType();
            this.addDisabledSpawner(spawner.getLocation(), mobname);
        }
    }

    public void addDisabledSpawner(Location spawner, EntityType mobname) {
        int startx = spawner.getBlockX() - 4;
        int endx = startx + 8;
        int starty = spawner.getBlockY() - 1;
        int endy = starty + 8;
        int startz = spawner.getBlockZ() - 4;
        int endz = startz + 8;
        this.disabledspawnerlocs.put(this.locationBuilder(spawner), new Integer(mobname.getTypeId()));
        int x = startx;
        while (x < endx) {
            int y = starty;
            while (y < endy) {
                int z = startz;
                while (z < endz) {
                    String location = String.valueOf(x) + "." + y + "." + z + "." + spawner.getWorld().getName();
                    if (this.disabledspawners.containsKey(location)) {
                        this.disabledspawners.get(location).add(mobname);
                    } else {
                        LinkedList<EntityType> tlist = new LinkedList<EntityType>();
                        tlist.add(mobname);
                        this.disabledspawners.put(location, tlist);
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        this.saveDisabledSpawners();
    }

    public void removeDisabledSpawner(Block spawner) {
        if (spawner.getType() == Material.MOB_SPAWNER) {
            CreatureSpawner theSpawner = (CreatureSpawner)spawner.getState();
            EntityType mobname = theSpawner.getSpawnedType();
            this.removeDisabledSpawner(spawner.getLocation(), mobname);
        }
    }

    public void removeDisabledSpawner(Location spawner, EntityType mobname) {
        int startx = spawner.getBlockX() - 4;
        int endx = startx + 8;
        int starty = spawner.getBlockY() - 1;
        int endy = starty + 8;
        int startz = spawner.getBlockZ() - 4;
        int endz = startz + 8;
        this.disabledspawnerlocs.remove(this.locationBuilder(spawner));
        int x = startx;
        while (x < endx) {
            int y = starty;
            while (y < endy) {
                int z = startz;
                while (z < endz) {
                    String location = String.valueOf(x) + "." + y + "." + z + "." + spawner.getWorld().getName();
                    if (this.disabledspawners.containsKey(location)) {
                        this.disabledspawners.get(location).remove(mobname);
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        this.saveDisabledSpawners();
    }

    public void saveDisabledSpawners() {
        try {
            ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(new File(this.blocksavefile)));
            out.writeObject(this.disabledspawnerlocs);
            out.flush();
            out.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void loadDisabledSpawners() {
        try {
            ObjectInputStream out = new ObjectInputStream(new FileInputStream(new File(this.blocksavefile)));
            this.disabledspawnerlocs = (ConcurrentHashMap)out.readObject();
            Set keys = this.disabledspawnerlocs.keySet();
            for (String key : keys) {
                try {
                    int mobtype = this.disabledspawnerlocs.get(key);
                    EntityType type = EntityType.fromId((int)mobtype);
                    String[] location = key.split("\\.");
                    String destworld = location[3];
                    int x = Integer.parseInt(location[0]);
                    int y = Integer.parseInt(location[1]);
                    int z = Integer.parseInt(location[2]);
                    int startx = x - 4;
                    int endx = startx + 8;
                    int starty = y - 1;
                    int endy = starty + 8;
                    int startz = z - 4;
                    int endz = startz + 8;
                    int x1 = startx;
                    while (x1 < endx) {
                        int y1 = starty;
                        while (y1 < endy) {
                            int z1 = startz;
                            while (z1 < endz) {
                                String slocation = String.valueOf(x1) + "." + y1 + "." + z1 + "." + destworld;
                                if (this.disabledspawners.containsKey(slocation)) {
                                    this.disabledspawners.get(slocation).add(type);
                                } else {
                                    LinkedList<EntityType> tlist = new LinkedList<EntityType>();
                                    tlist.add(type);
                                    this.disabledspawners.put(slocation, tlist);
                                }
                                ++z1;
                            }
                            ++y1;
                        }
                        ++x1;
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

