/*
 * Decompiled with CFR 0.152.
 */
package tux2.MonsterBox;

import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.getspout.spoutapi.event.screen.ButtonClickEvent;
import org.getspout.spoutapi.gui.Button;
import org.getspout.spoutapi.player.SpoutPlayer;
import tux2.MonsterBox.MonsterBox;

public class MonsterBoxScreenListener
implements Listener {
    MonsterBox plugin;

    public MonsterBoxScreenListener(MonsterBox plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onButtonClick(ButtonClickEvent event) {
        if (this.plugin == event.getButton().getPlugin()) {
            Button eventbutton = event.getButton();
            String completebutton = eventbutton.getText();
            String[] buttonsplit = completebutton.split(" ");
            String mobname = buttonsplit[buttonsplit.length - 1];
            SpoutPlayer player = event.getPlayer();
            if (mobname.equalsIgnoreCase("close")) {
                player.getMainScreen().closePopup();
            } else if (this.plugin.hasPermissions((Player)player, "monsterbox.set")) {
                if (this.plugin.hasPermissions((Player)player, "monsterbox.spawn." + mobname.toLowerCase())) {
                    Block targetblock = player.getTargetBlock(this.plugin.transparentBlocks, 40);
                    if (this.plugin.useiconomy && this.plugin.hasEconomy()) {
                        if (this.plugin.hasPermissions((Player)player, "monsterbox.free")) {
                            if (this.plugin.setSpawner(targetblock, mobname)) {
                                player.sendNotification("Mob Spawner changed!", String.valueOf(this.plugin.capitalCase(mobname)) + "s galore!", Material.MOB_SPAWNER);
                                player.getMainScreen().closePopup();
                            } else {
                                player.sendNotification("Mob Unavailable", "Invalid mob type.", Material.FIRE);
                            }
                        } else if (this.plugin.iConomy.hasAccount(player.getName())) {
                            double balance = this.plugin.iConomy.getBalance(player.getName());
                            if (balance >= this.plugin.getMobPrice(mobname)) {
                                if (this.plugin.setSpawner(targetblock, mobname)) {
                                    this.plugin.iConomy.withdrawPlayer(player.getName(), this.plugin.getMobPrice(mobname));
                                    player.sendNotification("Mob Spawner changed!", String.valueOf(this.plugin.capitalCase(mobname)) + "s galore!", Material.MOB_SPAWNER);
                                    player.getMainScreen().closePopup();
                                } else {
                                    player.sendNotification("Mob Unavailable", "Invalid mob type.", Material.FIRE);
                                }
                            } else {
                                player.sendNotification("Insufficient Funds!", "You need " + this.plugin.iConomy.format(this.plugin.getMobPrice(mobname)) + "!", Material.MOB_SPAWNER);
                            }
                        } else {
                            player.sendNotification("No Bank account!", "You need a bank account and " + this.plugin.iConomy.format(this.plugin.getMobPrice(mobname)) + "!", Material.MOB_SPAWNER);
                        }
                    } else if (this.plugin.setSpawner(targetblock, mobname)) {
                        player.sendNotification("Mob Spawner changed!", String.valueOf(this.plugin.capitalCase(mobname)) + "s galore!", Material.MOB_SPAWNER);
                        player.getMainScreen().closePopup();
                    } else {
                        player.sendNotification("Mob Unavailable", "Invalid mob type.", Material.FIRE);
                    }
                } else {
                    player.sendNotification("Mob Unavailable", "Permission denied.", Material.FIRE);
                }
            } else {
                player.sendMessage(ChatColor.RED + "You don't have permission to change spawner types!");
                player.getMainScreen().closePopup();
            }
        }
    }
}

